//This program finds the poles and zeros of H(z)=z^2/(z^3+2.z^2-z-2) and gives the pole-zero plot in Z-Plane  
//Windows 10
//Scilab 6.1.0
clear 
clc
a=poly([0 0 1],"z","coeff")
b=poly([-2 -1 2 1],"z","coeff")
z=roots(a);
p=roots(b);
disp('The poles of the given H(z) are')
disp(p)
disp('The zeros of the given H(z) are')
disp(z)
h=syslin('d', a/b)
disp('The Transfer Function is H(z)=',h)
plzr(h)
title('Pole-Zero plot  of H(z)=z^2/(z^3+2.z^2-z-2)')

//output Test Case
//"The poles of the given H(z) are"
//   1. + 0.i
// -2. + 0.i
// -1. + 0.i
//"The zeros of the given H(z) are"
//   0. + 0.i
 //  0. + 0.i
 // "The Transfer Function is H(z)="              
//         z²        
 //  --------------  
 //  -2 -z +2z² +z³  
